<?php
// ========================================================================
// PM Moderation
// Version 1.0
// ------------------------------------------------------------------------
// MODCP/MODERATE_PM.PHP - Lets Admin and Moderators moderate PMs
// ------------------------------------------------------------------------
// Written by Alan Wagstaff
// Copyright (C) 2006 Alan Wagstaff
// ========================================================================

// Cludge vB's notice errors
error_reporting(E_ALL & ~E_NOTICE);

// Defines and includes
$phrasegroups = array('moderatepm');
require_once('./global.php');
require_once(DIR . '/includes/functions.php');

// Access check
if (!($permissions['moderatepm_permissions'] & $vbulletin->bf_ugp['moderatepm_permissions']['canmoderatepm']))
{
	print_cp_no_permission();
}

// Log what they're doing
log_admin_action();

if (empty($_REQUEST['do']))
{
	$_REQUEST['do'] = 'list';
}

print_cp_header($vbphrase[modpm_moderate_private_messages]);

// ========================================================================
// Send or Delete the selected PMs
if ($_POST['do'] == 'update')
{

	$vbulletin->input->clean_array_gpc('p', array(
		'selected'			=> TYPE_ARRAY_UINT,
		'pmid'				=> TYPE_UINT,
		'recipients'		=> TYPE_STR,
		'recipients_bcc'	=> TYPE_STR,
		'title'				=> TYPE_STR,
		'message'			=> TYPE_STR
		));

	// We're dealing with just 1 PM
	if (!empty($vbulletin->GPC['pmid']))
	{
		$vbulletin->GPC['selected'][$vbulletin->GPC['pmid']] = 1;
	}

	// Delete or Save?
	if (isset($_POST['delete']))
	{

		// ========================================================================
		// Delete the selected PMs
		$delete_q = "DELETE FROM " . TABLE_PREFIX . "moderation_pm
			WHERE id IN (" . implode(',', array_keys($vbulletin->GPC['selected'])) . ")";

		$vbulletin->db->query_write($delete_q);

		// Back to the PM list
		define('CP_REDIRECT', 'moderate_pm.php?do=list');
		print_stop_message('modpm_private_messages_deleted_sucessfully');

	}
	else 
	{

		// ========================================================================
		// Send the selected PMs
		$fetch_pm_q = "SELECT id, dateline, pmdetails, fromuserid, fromusername, title, message, recipients, recipients_bcc
			FROM " . TABLE_PREFIX . "moderation_pm
			WHERE id IN (" . implode(',', array_keys($vbulletin->GPC['selected'])) . ")";

		$fetch_pm_r = $vbulletin->db->query_read($fetch_pm_q);

		while ($fetch_pm_a = $vbulletin->db->fetch_array($fetch_pm_r))
		{
			// Create an array of PMs that we need to send
			$send_a[$fetch_pm_a['id']]['dateline'] = $fetch_pm_a['dateline'];
			$send_a[$fetch_pm_a['id']]['pmdetails'] = $fetch_pm_a['pmdetails'];
			$send_a[$fetch_pm_a['id']]['fromuserid'] = $fetch_pm_a['fromuserid'];
			$send_a[$fetch_pm_a['id']]['fromusername'] = $fetch_pm_a['fromusername'];
			$send_a[$fetch_pm_a['id']]['title'] = $fetch_pm_a['title'];
			$send_a[$fetch_pm_a['id']]['message'] = $fetch_pm_a['message'];
			$send_a[$fetch_pm_a['id']]['recipients'] = $fetch_pm_a['recipients'];
			$send_a[$fetch_pm_a['id']]['recipients_bcc'] = $fetch_pm_a['recipients_bcc'];
		}

		// Send the PMs
		foreach (array_keys($vbulletin->GPC['selected']) AS $pmid)
		{
			$pmdm =& datamanager_init('PM', $vbulletin, ERRTYPE_ARRAY);

			$pmdetails_a = unserialize($send_a[$pmid]['pmdetails']);

			$pmdm->overide = true;

			$pmdm->set_info('savecopy',      $pmdetails_a['savecopy']);
			$pmdm->set_info('receipt',       $pmdetails_a['receipt']);
			$pmdm->set_info('cantrackpm',    $pmdetails_a['cantrackpm']);
			$pmdm->set_info('parentpmid',    $pmdetails_a['pmid']);
			$pmdm->set_info('forward',       $pmdetails_a['forward']);
			$pmdm->set_info('bccrecipients', ($vbulletin->GPC['recipients_bcc'] ? $vbulletin->GPC['recipients_bcc'] : $send_a[$pmid]['recipients_bcc']));

			$pm_title = ($vbulletin->GPC['title'] ? $vbulletin->GPC['title'] : $send_a[$pmid]['title']);
			$pm_text = ($vbulletin->GPC['message'] ? $vbulletin->GPC['message'] : $send_a[$pmid]['message']);
			
			$pmdm->set('fromuserid', $send_a[$pmid]['fromuserid']);
			$pmdm->set('fromusername', $send_a[$pmid]['fromusername']);
			$pmdm->setr('title', $pm_title);
			$pmdm->set_recipients(($vbulletin->GPC['recipients'] ? $vbulletin->GPC['recipients'] : $send_a[$pmid]['recipients']), $pmdetails_a['permissions'], 'cc');
			$pmdm->set_recipients(($vbulletin->GPC['recipients_bcc'] ? $vbulletin->GPC['recipients_bcc'] : $send_a[$pmid]['recipients_bcc']), $pmdetails_a['permissions'], 'bcc');
			$pmdm->setr('message', $pm_text);
			$pmdm->setr('iconid', $pmdetails_a['iconid']);
			$pmdm->set('dateline', $send_a[$pmid]['dateline']);
			$pmdm->setr('showsignature', $pmdetails_a['signature']);
			$pmdm->set('allowsmilie', $pmdetails_a['disablesmilies'] ? 0 : 1);

			if (!$pmdm->errors)
			{
				$pmdm->save();
			}

			// Cleanup ready for the next one
			unset($pmdm);
		}

		// Remove the moderation_pm records for the PMs we've just sent
		$delete_q = "DELETE FROM " . TABLE_PREFIX . "moderation_pm
			WHERE id IN (" . implode(',', array_keys($vbulletin->GPC['selected'])) . ")";

		$vbulletin->db->query_write($delete_q);

	}

	// Back to the PM list
	define('CP_REDIRECT', 'moderate_pm.php?do=list');
	print_stop_message('modpm_private_messages_sent_sucessfully');

}

// ========================================================================
// List the PMs awaiting moderation
if ($_REQUEST['do'] == 'list')
{

	// Fetch the PM summeries
	$fetch_q = "SELECT id, dateline, fromuserid, fromusername, title, message, recipients, recipients_bcc
		FROM " . TABLE_PREFIX . "moderation_pm";

	$fetch_r = $vbulletin->db->query_read($fetch_q);

	while ($fetch_a = $vbulletin->db->fetch_array($fetch_r))
	{
		$pm_a[$fetch_a['id']]['date'] = $fetch_a['dateline'];
		$pm_a[$fetch_a['id']]['fromuserid'] = $fetch_a['fromuserid'];
		$pm_a[$fetch_a['id']]['fromusername'] = $fetch_a['fromusername'];
		$pm_a[$fetch_a['id']]['title'] = $fetch_a['title'];
		$pm_a[$fetch_a['id']]['message'] = $fetch_a['message'] . '...';
		$pm_a[$fetch_a['id']]['recipients'] = $fetch_a['recipients'];
		$pm_a[$fetch_a['id']]['recipients_bcc'] = $fetch_a['recipients_bcc'];
	}

	// Prepare the keyword array
	$keywords_a = preg_split('/\n/', $vbulletin->options['cit_modpm_keywords']);

	$match_keywords = false;

	if ((count($keywords_a) > 0) AND (!empty($keywords_a[0])))
	{
		$match_keywords = true;
	}

	// Display the PM list - Start
	print_form_header('moderate_pm', 'update');
	print_table_header($vbphrase['modpm_private_messages_awaiting_moderation'], 6);

	// Column headers
	$headings = array(
		$vbphrase['modpm_from'],
		$vbphrase['modpm_to'],
		$vbphrase['modpm_subject'],
		$vbphrase['modpm_keywords'],
		$vbphrase['modpm_date'],
		''
		);

	print_cells_row($headings, 0, 'thead', -4);

	// List the PMs
	if (count($pm_a) > 0)
	{
		foreach ($pm_a AS $id => $pmdetails)
		{
			$cells = array();

			// Strip BBCode from message text for later use
			$clean_messagetext = strip_bbcode($pmdetails['message'], false, false, false);

			// From
			$cells[] = '<a href="' . $vbulletin->options['bburl'] . '/' . $vbulletin->config['Misc']['admincpdir'] . '/user.php?do=edit&amp;u=' . $pmdetails['fromuserid'] . '" target="_blank">' . $pmdetails['fromusername'] . '</a>';

			// To
			if (preg_match('/(?<!&#[0-9]{3}|&#[0-9]{4}|&#[0-9]{5});/', $pmdetails['recipients']))
			{
				$recipientlist = preg_split('/(?<!&#[0-9]{3}|&#[0-9]{4}|&#[0-9]{5});/', $pmdetails['recipients'], -1, PREG_SPLIT_NO_EMPTY);
				foreach ($recipientlist AS $recipient)
				{
					$recipient = trim($recipient);
					if ($recipient != '')
					{
						$recipients_a[] = htmlspecialchars_uni($recipient);
					}
				}
			}
			else 
			{
				// Single recipient
				$recipients_a[] = htmlspecialchars_uni(trim($pmdetails['recipients']));
			}

			if (!empty($pmdetails['recipients_bcc']))
			{
				if (preg_match('/(?<!&#[0-9]{3}|&#[0-9]{4}|&#[0-9]{5});/', $pmdetails['recipients_bcc']))
				{
					$recipientlist = preg_split('/(?<!&#[0-9]{3}|&#[0-9]{4}|&#[0-9]{5});/', $pmdetails['recipients_bcc'], -1, PREG_SPLIT_NO_EMPTY);
					foreach ($recipientlist AS $recipient)
					{
						$recipient = trim($recipient);
						if ($recipient != '')
						{
							$recipients_bcc_a[] = htmlspecialchars_uni($recipient);
						}
					}
				}
				else 
				{
					$recipients_bcc_a[] = htmlspecialchars($pmdetails['recipients_bcc']);
				}
			}
			else
			{
				$recipients_bcc_a = array();
			}
			
			// Regular
			$recipient_tooltip = $vbphrase['modpm_regular_recipients'] . "\r\n";

			for ($i = 0; $i < count($recipients_a); $i++)
			{
				$recipient_tooltip .= trim($recipients_a[$i]);
				$recipient_tooltip .= ($i == count($recipients_a) - 1 ? '' : "\r\n");
			}

			// BCC
			$recipient_tooltip .= "\r\n\r\n" . $vbphrase['modpm_bcc_recipients'] . "\r\n";

			if (count($recipients_bcc_a) == 0)
			{
				$recipient_tooltip .= $vbphrase['modpm_none'];
			}
			else 
			{
				for ($i = 0; $i < count($recipients_bcc_a); $i++)
				{
					$recipient_tooltip .= trim($recipients_bcc_a[$i]);
					$recipient_tooltip .= ($i == count($recipients_bcc_a) - 1 ? '' : "\r\n");
				}
			}

			$cells[] = '<div title="' . $recipient_tooltip . '">' . (count($recipients_a) + count($recipients_bcc_a)) . ' ' . $vbphrase['modpm_recipients'] . '</div>';

			// Subject / substr'd message text
			$cells[] = '<a href="' . $vbulletin->options['bburl'] . '/' . $vbulletin->config['Misc']['modcpdir'] . '/moderate_pm.php?do=view&amp;pmid=' . $id . '" title="' . $clean_messagetext . '">' . $pmdetails['title'] . '</a>';

			// Keywords
			if ($match_keywords)
			{
				$keyword_tooltip = $vbphrase['modpm_matched_keywords'] . "\r\n";

				foreach ($keywords_a AS $keyword)
				{
					$matched[$keyword] = substr_count(strtolower($clean_messagetext), trim(strtolower($keyword)));
				}

				foreach ($matched AS $keyword => $count)
				{
					if ($count != 0)
					{
						$keyword_tooltip .= trim($keyword) . ' (' . $count . ")\r\n";
						$total_matched = $total_matched + $count;
					}
				}

				if ($total_matched > 0)
				{
					$cells[] = '<div title="' . $keyword_tooltip . '">' . $total_matched . ' ' . $vbphrase['modpm_matched'] . '</div>';
				}
				else 
				{
					$cells[] = $vbphrase['modpm_none'];
				}
			}
			else 
			{
				// No keyword list to check
				$cells[] = $vbphrase['modpm_none'];
			}

			// Date
			$cells[] = vbdate($vbulletin->options['dateformat'], $pmdetails['date'], true) . ' ' . vbdate($vbulletin->options['timeformat'], $pmdetails['date'], true);

			// Checkbox
			$cells[] = '<input type="checkbox" name="selected[' . $id . ']" id="pm_' .$id . '_selected" value="1">';

			print_cells_row($cells, false, false, -4);

			// Cleanup
			unset($recipient_tooltip);
			unset($keyword_tooltip);
			unset($total_matched);
			unset($recipients_a);
		}

		// Action buttons
		print_table_footer(6, '<input type="submit" class="button" name="save" value="' . $vbphrase['modpm_approve_selected'] . '" tabindex="1" />
			<input type="submit" class="button" name="delete" value="' . $vbphrase['modpm_reject_selected'] . '" tabindex="1" />
		');

	}
	else 
	{
		// No PMs to moderate
		print_description_row($vbphrase['modpm_no_messages_to_moderate'], false, 6, false, 'center');
		print_table_footer();
	}

}

// ========================================================================
// View and Edit an individual PM
if ($_GET['do'] == 'view')
{

	$vbulletin->input->clean_array_gpc('g', array(
		'pmid'	=> TYPE_UINT
		));

	// Fetch the requested PM
	$fetch_pm_q = "SELECT dateline, fromuserid, fromusername, title, message, recipients, recipients_bcc
		FROM " . TABLE_PREFIX . "moderation_pm
		WHERE id = " . $vbulletin->GPC['pmid'] . "
		LIMIT 1";

	$fetch_pm_a = $vbulletin->db->query_first($fetch_pm_q);

	// Check it's valid
	if (count($fetch_pm_a) < 1)
	{
		print_stop_message('modpm_invalid_pm_selected');
	}

	// Display the PM
	print_form_header('moderate_pm', 'update');
	print_table_header($vbphrase['modpm_moderate_private_message'], 2);

	$_HIDDENFIELDS['pmid'] = $vbulletin->GPC['pmid'];
	print_hidden_fields();

	print_cells_row(array($vbphrase['modpm_date_sent'], vbdate($vbulletin->options['dateformat'], $fetch_pm_a['dateline'], true) . ' ' . vbdate($vbulletin->options['timeformat'], $fetch_pm_a['dateline'], true)), false, false, -1);
	print_cells_row(array($vbphrase['modpm_from'], '<a href="' . $vbulletin->options['bburl'] . '/' . $vbulletin->config['Misc']['admincpdir'] . '/user.php?do=edit&amp;u=' . $fetch_pm_a['fromuserid'] . '" target="_blank">' . $fetch_pm_a['fromusername'] . '</a>'), false, false, -1);
	print_input_row($vbphrase['modpm_recipients'], 'recipients', $fetch_pm_a['recipients'], true, 50);
	print_input_row($vbphrase['modpm_recipients_bcc'], 'recipients_bcc', $fetch_pm_a['recipients_bcc'], true, 50);

	print_hr_row();

	print_input_row($vbphrase['modpm_subject'], 'title', $fetch_pm_a['title'], true, 80);
	print_textarea_row($vbphrase['modpm_message'], 'message', $fetch_pm_a['message'], 15, 70);

	// Action buttons
	print_table_footer(5, '<input type="submit" class="button" name="save" value="' . $vbphrase['modpm_approve'] . '" tabindex="1" />
		<input type="submit" class="button" name="delete" value="' . $vbphrase['modpm_reject'] . '" tabindex="1" />
	');

}

print_cp_footer();

?>